definition module CMDatabase

import CMTypes
import StdiTasks 


// Sanity checks
checkUsersDB :: Role (Task Void) -> Task Void

checkPapersDB :: (Task Void) -> Task Void
                       
checkReviewsDB :: (Task Void) -> Task Void
                      
checkDB :: (Task [a]) ([a] -> Bool) (Task Void) String -> Task Void     
                                     

// Storage functions for users
usersId :: DBid [User]

readUsersDB :: Task [User]

readUsersByRoleDB :: Role -> Task [User]
                 
writeUsersDB :: [User] -> Task Void

lookupUserDB :: UserId -> Task User     

verifyUserDB :: Login -> Task (Maybe User)
                               
addUserDB :: User -> Task Void
                                   
updateUserDB :: UserId (User -> User) -> Task Void
                                     
updateUserConflictsDB :: UserId [(PaperId, Mark)] -> Task Void

initUsersDB :: Task Void

initUserDB :: [User] (String, Role) -> Task Void 
    
    
// Storage functions for papers           
papersId :: DBid [Paper]

readPapersDB :: Task [Paper]

writePapersDB :: [Paper] -> Task Void
                       
clearPapersDB :: Task Void                  

addPaperDB :: Paper -> Task Void
                    
initPapersDB :: Task Void
 
 
// Storage functions for reviews
reviewsId :: DBid [Review]

readReviewsDB :: Task [Review]

writeReviewsDB :: [Review] -> Task Void
                         
lookupReviewsDB :: Paper -> Task [Review]                       

addReviewDB :: PaperId UserId Review -> Task Void
                                                 

// Storage functions for judgments
judgmentId :: DBid [Judgment]

readJudgmentsDB :: Task [Judgment]

writeJudgmentsDB :: [Judgment] -> Task Void
                             
addJudgmentDB :: Judgment -> Task Void
                         
                 
// Storage functions for assigned reviewers                         
assignedReviewerId :: DBid [AssignedReviewer]

readAssignedReviewersDB :: Task [AssignedReviewer]                  

writeAssignedReviewersDB :: [AssignedReviewer] -> Task Void
                                             
addAssignedReviewersDB :: [AssignedReviewer] -> Task Void                                                                                  
                       
splitAssignedReviewersDB :: [Paper] -> Task ([Paper], [Paper], [Paper], [Paper])
